import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay_agent/core/helper/date_converter.dart';
import 'package:viserpay_agent/core/helper/string_format_helper.dart';
import 'package:viserpay_agent/core/utils/dimensions.dart';
import 'package:viserpay_agent/core/utils/my_strings.dart';
import 'package:viserpay_agent/data/controller/transaction/transaction_history_controller.dart';
import 'package:viserpay_agent/view/components/bottom-sheet/bottom_sheet_header_row.dart';
import 'package:viserpay_agent/view/components/column_widget/card_column.dart';

class TransactionHistoryBottomSheet extends StatelessWidget {
  final int index;
  const TransactionHistoryBottomSheet({super.key, required this.index});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<TransactionHistoryController>(
      builder: (controller) => Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          const BottomSheetHeaderRow(header: MyStrings.details),
          const SizedBox(height: Dimensions.space15),
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Expanded(
                  child: CardColumn(
                header: MyStrings.transactionId.tr,
                body: controller.transactionList[index].trx ?? "",
              )),
              Expanded(
                child: CardColumn(
                  alignmentEnd: true,
                  header: MyStrings.date.tr,
                  body: DateConverter.convertIsoToString(
                    controller.transactionList[index].createdAt ?? "",
                  ),
                ),
              ),
            ],
          ),
          const SizedBox(height: Dimensions.space15),
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Expanded(
                child: CardColumn(
                    header: MyStrings.amount.tr,
                    body: "${controller.currencySym}${Converter.formatNumber(
                      controller.transactionList[index].beforeCharge ?? "",
                    )}"),
              ),
              Expanded(
                child: CardColumn(
                    alignmentEnd: true,
                    header: MyStrings.charge.tr,
                    body: "${controller.currencySym}${Converter.formatNumber(
                      controller.transactionList[index].charge ?? "",
                    )}"),
              ),
            ],
          ),
          const SizedBox(height: Dimensions.space15),
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Expanded(
                child: CardColumn(
                  alignmentEnd: false,
                  header: MyStrings.finalAmount.tr,
                  body: "${controller.currencySym}${Converter.formatNumber(
                    controller.transactionList[index].amount ?? "",
                  )}",
                ),
              ),
              Expanded(
                child: CardColumn(
                  alignmentEnd: true,
                  header: MyStrings.remainingBalance.tr,
                  body: "${Converter.formatNumber(controller.transactionList[index].postBalance ?? "")} ${controller.currency}",
                ),
              ),
            ],
          ),
          const SizedBox(height: Dimensions.space15),
          CardColumn(
            alignmentEnd: false,
            header: MyStrings.details.tr,
            body: "${controller.transactionList[index].details}",
            bodyMaxLine: 8,
          )
        ],
      ),
    );
  }
}
